<?php
/**
 * Easy Header Footer Settings
 */

 // do not allow direct access
if(!defined('ABSPATH')){
    exit;
}


// setting up the admin menu
function EZ_EasyHeaderFooter_add_admin_menu(){
    add_menu_page(
        'Easy Header Footer Settings',					// The text to be displayed in the title tags of the page when the menu is selected.
        'EZ Header Footer',								// The text to be used for the menu.
        'manage_options',								// The capability required for this menu to be displayed to the user.
        'easy-header-footer-settings',   				// The slug name to refer to this menu by.
        'EZ_EasyHeaderFooter_settings_page',			// The function to be called to output the content for this page.        
        'dashicons-code-standards'						// The name of the icon that is to be used.
    );
}
add_action('admin_menu', 'EZ_EasyHeaderFooter_add_admin_menu');


// clean the data before going into db
function EZ_EasyHeaderFooter_settings_init(){
    register_setting('easy_header_footer_settings', 'easy_header_code', ['sanitize_callback' => 'ez_easy_sanitize_code']);   
    register_setting('easy_header_footer_settings', 'easy_footer_code', ['sanitize_callback' => 'ez_easy_sanitize_code']);
}
add_action('admin_init', 'EZ_EasyHeaderFooter_settings_init');

// setting up the layout for the admin settings page
function EZ_EasyHeaderFooter_settings_page(){
    ?>
    <div class="wrap">
        <h1>Easy Header Footer Settings</h1>
        <form action="options.php" method="post">
            <?php 
                // the settings_fields is using the name out of register_setting above
                settings_fields('easy_header_footer_settings');
                do_settings_sections('easy_header_footer_settings');
            ?>
            <label for="easy_hc"><h2>Header Code</h2></label>
            <textarea id="easy_hc" name="easy_header_code" rows="10" cols="70" class="large-text code"><?php echo esc_textarea(get_option('easy_header_code')); ?></textarea>            

            <p class="description">
                Note: Make sure to use style or script starting and closing tags along with the code.
            </p>            

            <label for="easy_fc"><h2>Footer Code</h2></label>
            <textarea id="easy_fc" name="easy_footer_code" rows="10" cols="70" class="large-text code"><?php echo esc_textarea(get_option('easy_footer_code')); ?></textarea>

            <p class="description">
                Note: Make sure to use style or script starting and closing tags along with the code.
            </p>

            <?php submit_button('Save Code', 'primary'); ?>

        </form>
    </div>
 <?php
}

// sanitize data
function ez_easy_sanitize_code($code){
    $allowed_html = array(
        'script' => array(),
        'style' => array()
    );
    return wp_kses($code, $allowed_html);
}

